/****************************************************************
 *  Exemple de programme utilisant la librairie CEC_lib         *
 *  Les fichiers CEC_lib.cpp et CEC_lib.h doivent être dans le  *
 *  même répertoire que celui de ce sketch.                     *
 *                                                              *
 ****************************************************************/

//ed/* Programmation du moteur Course en Cours */
#include <Arduino.h>
#include <stdlib.h>
#include <stdio.h>
#include <math.h>
#include "CEC_lib.h"
/* Fonctions de configuration */

#define mySerial Serial

// Instanciation du moteur CeC
Moteur monMoteur;

float dureeCourse = 6.0f;
float longueurpiste = 15.0f;
float diametreRoue = 62.0f;
bool BilanRecue = false;
int typefin=0;

void setup()
{
  delay(100);
  mySerial.begin(115200);
  while (!mySerial) {
  ; // wait for serial port to connect. Needed for Native USB only
  }
  mySerial.println();
  mySerial.println(F("~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~"));
  mySerial.println(F(" Exemple de programme Arduino"));
  mySerial.println(F("~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~"));
  mySerial.println(F("-- Début du programme --"));
  mySerial.println(F("Setup.."));
  //monMoteur.setEchoOff(); // Arrète la sortie texte moteur. Pour rétablir: SetEchoOn()
  monMoteur.start(115200);  // Ouvre la liaison avec le moteur
  mySerial.println(F("setup: OK\n"));
  delay(1000);
}

void loop()
{
  int i=0;                  // variable d'indice
  int myCar;                // Variable pour un caractère
  int err = 0;              // Variable d'erreur
  bool bContinue = true;    // Flag de continuation du processus
  byte incomingByte = ' ';  // caractère d'entrée
  byte valByte;             // valeur byte

  // Message d'accueil de boucle
  mySerial.println(F("--Loop ('g' pour lancer (go)):"));

  // Attente du caractère de lancement
  while (incomingByte != 'g') // Tant que le caractère n'est pas le bon
  {
  if (mySerial.available() > 0) // Test si il y a des caractères à lire
      incomingByte = mySerial.read(); // Si oui: lit le 1er caractère
  delay(1);
  }

  // -- Bon caractère lu: début du traitement -- //
  incomingByte = ' '; // réinitialisation du caractère reçu
  
  //-------------------DEBUT------------------//
  // 1 - Vider d'abord le buffer de reception moteur,
  //     au cas ou il y aurait encore des caractères dans le buffer
  mySerial.print(F("Purge de la liaison moteur.."));
  monMoteur.purge();
  mySerial.println(F("OK"));

  BilanRecue = false;
  
  //bContinue = false;  // STOP
  
  //////////////////////////////////////////////////////////////////////////
  //   exemple d'utilisation des fonctions de récupération des infos      //
  //////////////////////////////////////////////////////////////////////////

  // **** Demande de lecture des informations moteur ****
  if(bContinue)
  {
    int n = 3;    // La 1ère communication peut ne pas passer : 3 essais

    mySerial.println();
    mySerial.println(F("~~~~ Partie Info ~~~~"));
    mySerial.println(F("~~~~~~~~~~~~~~~~~~~~~"));
    
    while ((err = monMoteur.readInfo()) < 0 && n-- > 0)
      delay(5);
      
    if(err < 0)
    { // Si erreur:
      mySerial.print(F("err: "));
      mySerial.println(err);
      bContinue = (err >= 0);
    }
    else 
    {
    // Utilisation des méthodes de récupération
    // des paramètres d'information
      byte vMaj, vMin;
      mySerial.print(F("version mère:    HW="));
      monMoteur.printInfoVersion(CEC_VERSION_MERE_HARD);
      mySerial.print(F(" SW="));
      monMoteur.printInfoVersion(CEC_VERSION_MERE_SOFT);  
      mySerial.print(F("\nversion moteur:  HW="));
      monMoteur.printInfoVersion(CEC_VERSION_MOT_HARD);  
      mySerial.print(F(" SW="));
      monMoteur.printInfoVersion(CEC_VERSION_MOT_SOFT);  
      mySerial.print(F("\nversion capteur: HW="));
      monMoteur.printInfoVersion(CEC_VERSION_CAPT_HARD);  
      mySerial.print(F(" SW="));
      monMoteur.printInfoVersion(CEC_VERSION_CAPT_SOFT); 
      mySerial.println();
    }
  }  
  delay(100);

  //bContinue = false;  // STOP

  if(bContinue)
  {
    // Vérifie la bonne connexion du moteur à l'app
    err = monMoteur.getInfoConnex();
    mySerial.print(F("getInfoConnex: "));
    mySerial.println(err);
    bContinue = (err >= 0);  // pour s'arreter si le moteur n'est pas connecté
  }
  delay(100);

  
  //////////////////////////////////////////////////////////////////////////
  //   exemple d'utilisation des fonctions de configuration               //
  //////////////////////////////////////////////////////////////////////////

  if(bContinue)
  {
    // **** Demande de lecture de la configuration moteur ****
    mySerial.println();
    mySerial.println(F("~~~~~~ Partie Config ~~~~~~~"));
    mySerial.println(F("~~ Lecture Config. Moteur ~~"));
    mySerial.println(F("~~~~~~~~~~~~~~~~~~~~~~~~~~~~"));

    int n = 3;    // La 1ère communication peut ne pas passer : 3 essais
    while ((err = monMoteur.readConfig()) < 0 && n-- > 0)
      delay(5);
      
    if(err < 0)
    { // Si erreur:
      mySerial.print(F("err: "));
      mySerial.println(err);
      bContinue = (err >= 0);
    }
    else
    {
      // Utilisation des méthodes de récupération
      // des paramètres de configuration
      unsigned int myValUInt;
      myValUInt = monMoteur.getConfigLongueurPiste();
      mySerial.print(F("Longueur Piste: "));
      mySerial.print(myValUInt, DEC);
      mySerial.print(F(" 0x"));
      mySerial.println(myValUInt, HEX);
  
      myValUInt = monMoteur.getConfigTailleDamier();
      mySerial.print(F("Damier: "));
      mySerial.print(myValUInt, DEC);
      mySerial.print(F(" 0x"));
      mySerial.println(myValUInt, HEX);
  
      myValUInt = monMoteur.getConfigDiametreRoues();
      mySerial.print(F("Diam.Roue: "));
      mySerial.print(myValUInt, DEC);
      mySerial.print(F(" 0x"));
      mySerial.println(myValUInt, HEX);
  
      myValUInt = monMoteur.getConfigPignon();
      mySerial.print(F("  Pignon: "));
      mySerial.println(myValUInt, DEC);
  
      myValUInt = monMoteur.getConfigCouronne();
      mySerial.print(F("  Couronne: "));
      mySerial.println(myValUInt, DEC);
  
      myValUInt = monMoteur.getConfigVehicule();
      mySerial.print(F("ConfigVehicule: "));
      mySerial.println(myValUInt, DEC);
  
      myValUInt = monMoteur.getConfigCourse();
      mySerial.print(F("ConfigCourse: "));
      mySerial.println(myValUInt, DEC);
  
      myValUInt = monMoteur.getConfigPeriodeEch();
      mySerial.print(F("Periode Echantillonnage: "));
      mySerial.println(myValUInt, DEC);
  
      myValUInt = monMoteur.getConfigTempsMaxCourse();
      mySerial.print(F("Temps Max Course: "));
      mySerial.println(myValUInt, DEC);
  
      myValUInt = monMoteur.getConfigVitesseMin();
      mySerial.print(F("Vitesse Min: "));
      mySerial.println(myValUInt, DEC);
  
      myValUInt = monMoteur.getConfigVitesseMax();
      mySerial.print(F("Vitesse Max: "));
      mySerial.println(myValUInt, DEC);
  
      {
        int segment = 0;
        for (segment = 0;
             segment < CEC_CONFIG_SEGMENTS;
             segment++)
        {
          myValUInt = monMoteur.getConfigSegmentVitesse(segment);
          mySerial.print(F("Segment "));
          mySerial.print(segment, DEC);
          mySerial.print(F(" Vitesse: "));
          mySerial.println(myValUInt, DEC);
          myValUInt = monMoteur.getConfigSegmentTemps(segment);
          mySerial.print(F("Segment "));
          mySerial.print(segment, DEC);
          mySerial.print(F(" Temps: "));
          mySerial.println(myValUInt, DEC);
        }
      }
  
      myValUInt = monMoteur.getConfigVitesseLente();
      mySerial.print(F("Vitesse Lente: "));
      mySerial.println(myValUInt, DEC);
  
      myValUInt = monMoteur.getConfigTimeHeures();
      mySerial.print(F("Temps Hrs: "));
      mySerial.println(myValUInt, DEC);
  
      myValUInt = monMoteur.getConfigTimeMinutes();
      mySerial.print(F("Temps Min: "));
      mySerial.println(myValUInt, DEC);
  
      myValUInt = monMoteur.getConfigTimeSecondes();
      mySerial.print(F("Temps sec: "));
      mySerial.println(myValUInt, DEC);
  
      myValUInt = monMoteur.getConfigTimeMillisecondes();
      mySerial.print(F("Temps Mls: "));
      mySerial.println(myValUInt, DEC);    
    }
  }
  delay(10);

  //bContinue = false;  // STOP

  //////////////////////////////////////////////////////////////////////////
  //   exemple d'utilisation des fonctions de configuration               //
  //////////////////////////////////////////////////////////////////////////
  
  if(bContinue)
  {
    mySerial.println();
    mySerial.println(F("~~~~ Configuration de la course ~~~~"));
    mySerial.println(F("~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~"));
    monMoteur.initConfig();
    mySerial.print(F("setConfigTimeCourse("));
    mySerial.print(dureeCourse);
    mySerial.println(F(")"));
    monMoteur.setConfigTimeCourse(dureeCourse);     // duree de course (s)
    mySerial.print(F("setConfigLongueurPiste("));
    mySerial.print(longueurpiste);
    mySerial.println(F(")"));
    monMoteur.setConfigLongueurPiste(longueurpiste);// Longueur de la piste en mètres
    mySerial.print(F("setConfigCourseEndType("));
    mySerial.print(typefin);
    mySerial.println(F(")"));
    monMoteur.setConfigCourseEndType(typefin);      // choix du type de fin de course: 0 pour fin par zone, 1 pour fin par détection de ligne
    mySerial.print(F("setConfigDiametreRoues("));
    mySerial.print(diametreRoue);
    mySerial.println(F(")"));
    monMoteur.setConfigDiametreRoues(diametreRoue); // Configure le diamètre de roue (mm)
    monMoteur.setConfigSpeed(1.0f, 1.0f, 0);// SetSpeed(vitesse(m/s),temps(s), zone) en tout 10 zone de 0 à 9 configurables
    monMoteur.setConfigSpeed(3.0f, 2.0f, 1);
    monMoteur.setConfigSpeed(6.0f, 3.0f, 2);
      
    monMoteur.setConfigMotorisationType(CEC_TYPE_TRACTION);// 0 pour la monMoteurisation en propulsion et 1 pour la monMoteurisation en traction
        
    mySerial.println();
    mySerial.println(F("~~ Envoi de la config. ~~"));
    if((err = monMoteur.sendConfig()) < 0)//fonction configurant le moteur
    {
      mySerial.print(F("err: "));
      mySerial.println(err);
      bContinue = (err >= 0);
    }
    else
    {
      mySerial.print(F("sendConfig() Ok ("));
      mySerial.print(err);
      mySerial.println(F(")"));
    }
  }
  delay(100);
  
  //bContinue = false;  // STOP
  
  if(bContinue)
  {
    mySerial.println();
    mySerial.println(F("~~ Relecture de la config ~~"));
    int n = 3;    // La 1ère communication peut ne pas passer : 3 essais
    while ((err = monMoteur.readConfig()) < 0 && n-- > 0)   // Demande la trame config
      delay(5);
      
    if(err < 0)
    {
      mySerial.print(F("err: "));
      mySerial.println(err);
      bContinue = (err >= 0);
    }
    else
    {
      mySerial.println(F("Vérification des segments:"));
      for(int zone = 0; zone < 10; zone++)
      {
        monMoteur.getConfigSegmentVitesse(zone);
        monMoteur.getConfigSegmentTemps(zone);
      }
    }
  }
  delay(100);
    
  //bContinue = false;  // STOP

  
  //////////////////////////////////////////////////////////////////////////
  //   1er exemple d'utilisation des fonctions de mouvement Move          //
  //////////////////////////////////////////////////////////////////////////

  if(bContinue)
  {
    mySerial.println();
    mySerial.println(F("~~~~ Fonctions de Mouvement ~~~~"));
    mySerial.println(F("~~ moveStart et moveSpeedLimit ~~"));
    monMoteur.moveStart(500);//fonction permettant le départ du moteur
    //delay(1750);
    //monMoteur.moveSpeedLimit(0.50f);  // Limitation de vitesse à 0,5 m/s
  
    bContinue = true;
    
  //////////////////////////////////////////////////////////////////////////
  //   exemple d'utilisation des fonctions bilan durant la course         //
  //////////////////////////////////////////////////////////////////////////
    i = 70;
    bool bLimite = false;
    
    // Attente départ de course
    mySerial.println(F("Attente début de course."));
    while(bContinue && i > 0)
    {
      i--;
      err = monMoteur.ReadBilan();
      if(err  < 0)
      {
        bContinue = false;
        break;
      }
      else
      {
        int zone;
        unsigned int myTime;
        myTime = monMoteur.getBilanFinalTime();
        valByte = monMoteur.getBilanCourseEtat();
        zone = monMoteur.getBilanCourseZone();
        if(valByte  == CEC_SEQ_COU_COU)
        {
          float mySpeed = monMoteur.getBilanVitesse();
          mySerial.print(F("time="));
          mySerial.print(myTime);
          mySerial.print(F("ms, Zone="));
          mySerial.print(zone);
          mySerial.print(F(", V="));
          mySerial.print(mySpeed);
          mySerial.println(F("m/s\n\n"));
          break;
        }
        delay(100);
      }
    }
    
    
    // Attente fin de course
    mySerial.print(F("OK\nAttente fin de course.."));
    while(bContinue && i > 0)
    {
      i--;
      err = monMoteur.ReadBilan();
      if(err  < 0)
      {
        bContinue = false;
        break;
      }
      else
      {
        int zone;
        unsigned int myTime;
        valByte = monMoteur.getBilanCourseEtat();
        zone = monMoteur.getBilanCourseZone();
        myTime = monMoteur.getBilanFinalTime();
        float mySpeed = monMoteur.getBilanVitesse();
        mySerial.print(F("time="));
        mySerial.print(myTime);
        mySerial.print(F("ms, Zone="));
        mySerial.print(zone);
        mySerial.print(F(", V="));
        mySerial.print(mySpeed);
        mySerial.println(F("m/s"));


  //////////////////////////////////////////////////////////////////////////
  //   exemple d'utilisation des fonctions de limitation de vitesse       //
  //////////////////////////////////////////////////////////////////////////

        if(!bLimite)
        {
          if(mySpeed > 1.0f && (err == CEC_SEQ_COU_COU || err == CEC_SEQ_COU_CAL))
          {
            monMoteur.moveSpeedLimit(0.5f);  // Limitation de vitesse à 0,5 m/s
            bLimite = true;
            mySerial.print(F("->limitation à 0.5 m/s"));   
          }
        }
        
        if(err == CEC_SEQ_COU_FIN_LIGNE || err == CEC_SEQ_COU_FIN || err == CEC_SEQ_COU_ATT)
        break;  // Sortie de la boucle while    
        delay(100);
      }
    }
    mySerial.println(F("OK"));

  //////////////////////////////////////////////////////////////////////////
  //   Autre exemple d'utilisation des fonctions de mouvement Move        //
  //////////////////////////////////////////////////////////////////////////

    mySerial.println(F("Départ de Course :"));
    mySerial.println(F("moveStart: dans 1000ms .."));
    monMoteur.moveStart(1000);
    mySerial.println(F("delai: de 1000ms .."));
    delay(1000);
    mySerial.println(F("movePause: pendant 1500ms .."));
    monMoteur.movePause(1500);
    mySerial.println(F("move pendant 500ms .."));
    delay(500);
    mySerial.println(F("moveSpeedLimit: 0.5m/s .."));
    monMoteur.moveSpeedLimit(0.5f);
    mySerial.println(F("moveStop: dans 1000ms .."));
    monMoteur.moveStop(1000);
    mySerial.println(F("configMoveForward: pendant 1000ms à 50 cm/s.."));
    monMoteur.configMoveForward(1000,50);
    mySerial.println(F("configMoveBackward: pendant 1000ms à 50 cm/s.."));
    monMoteur.configMoveBackward(1000,50);
    delay(100);


    
  //////////////////////////////////////////////////////////////////////////
  //   exemple d'utilisation des fonctions bilan en fin de course         //
  //////////////////////////////////////////////////////////////////////////
    delay(dureeCourse * 1000);
    while (BilanRecue != true)
    {
      //--------------------LECTURE-----------------------
  
      // Permet la récupération des informations de fin de la course //
      monMoteur.ReadBilan();                   // Trame Bilan: réception des valeurs
      monMoteur.getBilanFinalTime();           // Récupère le temps final de la course
      monMoteur.getBilanFinalDistance();       // Récupère la distance finale de la course
      monMoteur.getBilanFinalVmoy();           // Récupère la vitesse moyenne finale de la course
      monMoteur.getBilanFinalVmax();           // Récupère la vitesse maximale finale de la course
      monMoteur.getBilanFinalCumulCourant();   // Récupère le cumul de courant de la course
      monMoteur.getBilanFinalPconso();         // Récupère la puissance consommée de la course
      monMoteur.getBilanTypeDepart();          // Récupère le type de départ
      monMoteur.getBilanTypeFin();             // Récupère le type d'arrivée
      monMoteur.getBilanFinalAccelMoy();       // Récupère l'acceleration moyenne finale de la course
  
      monMoteur.getBilanAccel();               // Récupère l'acceleration
      monMoteur.getBilanVitesse();             // Récupère la vitesse
      monMoteur.getBilanPosition();            // Récupère la position
      monMoteur.getBilanCourseEtat();          // Récupère l'état actuel de course 
      monMoteur.getBilanCourseZone();          // Récupère la zone actuelle de course
      BilanRecue = true;
    }
      delay(100);
       
  //////////////////////////////////////////////////////////////////////////    
  //   exemple d'utilisation des fonctions de récupération des mesures    //
  //   avertissement: il y a encore quelques bugs liés à ses fonctions    //
  //////////////////////////////////////////////////////////////////////////    
       
    monMoteur.ReadMesures();
    
    mySerial.println(F("\nTrame de mesures :"));
    monMoteur.getMesureNum();
    monMoteur.getMesureAccel(CEC_ACCEL_AXE_X);
    monMoteur.getMesureGyro(CEC_GYRO_AXE_X);
    monMoteur.getMesureMagneto(CEC_MAGNETO_AXE_X);
    monMoteur.getMesureRpm();
    monMoteur.getMesureSpeed();
    monMoteur.getMesureDistance();
    monMoteur.getMesureColor();
    monMoteur.getMesureTension();
    monMoteur.getMesureCourant();
    monMoteur.getMesureTemp();
    
      /* 
  ///////////////////////////////////////////////////////////////////////
    }
  
  */
  }
}
